/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.Plot;
import org.autoplot.state.StatePersistence;
import org.das2.datum.DatumRange;
import org.das2.qds.QDataSet;
import org.das2.qstream.SimpleStreamFormatter;
import org.das2.qstream.StreamException;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class EmbedDataExperiment {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToZip(ZipOutputStream out, String name, File f) throws FileNotFoundException, IOException {
        ZipEntry e = new ZipEntry(name);
        try (FileChannel ic = null;){
            int c;
            ic = new FileInputStream(f).getChannel();
            out.putNextEntry(e);
            byte[] bbuf = new byte[2048];
            ByteBuffer buf = ByteBuffer.wrap(bbuf);
            while ((c = ic.read(buf)) > 0) {
                out.write(bbuf, 0, c);
                buf.flip();
            }
            out.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToZip(ZipOutputStream out, String name, InputStream in) throws FileNotFoundException, IOException {
        ZipEntry e = new ZipEntry(name);
        try (ReadableByteChannel ic = null;){
            int c;
            ic = Channels.newChannel(in);
            out.putNextEntry(e);
            byte[] bbuf = new byte[2048];
            ByteBuffer buf = ByteBuffer.wrap(bbuf);
            while ((c = ic.read(buf)) > 0) {
                out.write(bbuf, 0, c);
                buf.flip();
            }
            out.closeEntry();
        }
    }

    private static URI makeCanonical(URI uri) {
        try {
            String path = uri.getPath();
            String[] pp = path.split("/");
            StringBuilder np = new StringBuilder();
            for (String p : pp) {
                if (p.length() <= 0) continue;
                np.append("/");
                np.append(p);
            }
            path = np.toString();
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(EmbedDataExperiment.class.getName()).log(Level.SEVERE, null, ex);
            return uri;
        }
    }

    private static boolean hasNoResource(URISplit split) {
        return split.resourceUri == null || "vap+das2server".equalsIgnoreCase(split.vapScheme);
    }

    private static Set<URI> getResources(Application dom) {
        HashSet<URI> result = new HashSet<URI>();
        for (DataSourceFilter dataSourceFilter : dom.getDataSourceFilters()) {
            String suri = dataSourceFilter.getUri();
            EmbedDataExperiment.maybeAddResource(suri, dom, result);
        }
        for (DomNode domNode : dom.getPlots()) {
            String s = ((Plot)domNode).getTicksURI();
            EmbedDataExperiment.maybeAddResource(s, dom, result);
        }
        String s = dom.getEventsListUri();
        EmbedDataExperiment.maybeAddResource(s, dom, result);
        return result;
    }

    private static boolean maybeAddResource(String suri, Application dom, Set<URI> result) {
        if (suri.trim().length() == 0) {
            return false;
        }
        URISplit split = URISplit.parse((String)suri);
        if (split.resourceUri != null) {
            URI uri = EmbedDataExperiment.makeCanonical(split.resourceUri);
            if (EmbedDataExperiment.hasNoResource(split)) {
                return false;
            }
            if (DataSetURI.isAggregating((String)uri.toString())) {
                try {
                    String[] rr;
                    for (String r : rr = DataSetURI.unaggregate((String)uri.toString(), (DatumRange)dom.getTimeRange())) {
                        try {
                            result.add(new URI(r));
                        }
                        catch (URISyntaxException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                }
                catch (FileSystem.FileSystemOfflineException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                catch (UnknownHostException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            } else {
                result.add(uri);
            }
        }
        return true;
    }

    private static String makeRelativeName(String commonPath, URI uri) {
        String name;
        if (uri.getScheme().equals("file")) {
            name = uri.getPath();
            if (name.startsWith(commonPath)) {
                name = uri.getScheme() + "/" + name.substring(commonPath.length());
            } else {
                name = uri.toString().replaceAll(":///", "/");
                name = name.replaceAll(":/", "/");
            }
        } else {
            name = uri.toString().replaceAll("://", "/");
        }
        name = name.replaceAll("//", "/");
        return name;
    }

    public static boolean isLocal(URI uri) {
        return uri.getScheme().equals("file");
    }

    public static void save(Application dom3, File f) throws FileNotFoundException, IOException {
        EmbedDataExperiment.save(dom3, f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Application dom3, File f, boolean onlyLocal) throws FileNotFoundException, IOException {
        int i;
        Application dom = dom3.getController().getApplicationModel().createState(false);
        QDataSet[] datasets = new QDataSet[dom.getDataSourceFilters().length];
        for (int i2 = 0; i2 < datasets.length; ++i2) {
            if (!dom3.getDataSourceFilters(i2).getUri().equals("vap+internal:")) continue;
            datasets[i2] = dom3.getDataSourceFilters(i2).getController().getDataSet();
        }
        Set<URI> uris = EmbedDataExperiment.getResources(dom);
        if (onlyLocal) {
            HashSet<URI> localUris = new HashSet<URI>();
            for (URI uri : uris) {
                if (!EmbedDataExperiment.isLocal(uri)) continue;
                localUris.add(uri);
            }
            uris = localUris;
        }
        String commonPath = null;
        for (URI uri : uris) {
            int i3;
            if (!uri.getScheme().equals("file")) continue;
            if (commonPath == null) {
                commonPath = uri.getPath();
                continue;
            }
            String path = uri.getPath();
            for (i3 = 0; i3 < Math.min(commonPath.length(), path.length()) && path.charAt(i3) == commonPath.charAt(i3); ++i3) {
            }
            commonPath = commonPath.substring(0, i3);
        }
        if (commonPath != null && !commonPath.endsWith("/") && (i = commonPath.lastIndexOf(47)) > -1) {
            commonPath = commonPath.substring(0, i + 1);
        }
        FileOutputStream fout = new FileOutputStream(f + ".tmp");
        ZipOutputStream out = null;
        try {
            String name;
            URISplit split;
            String uri;
            out = new ZipOutputStream(fout);
            for (URI uri2 : uris) {
                String string = EmbedDataExperiment.makeRelativeName(commonPath, uri2);
                File file1 = DataSetURI.getFile((URI)uri2, (ProgressMonitor)new NullProgressMonitor());
                EmbedDataExperiment.writeToZip(out, string, file1);
            }
            int nameGenCount = 0;
            int dsfCount = 0;
            for (DataSourceFilter dataSourceFilter : dom.getDataSourceFilters()) {
                uri = dataSourceFilter.getUri();
                split = URISplit.parse((String)uri);
                if (uri.trim().length() > 0 && !EmbedDataExperiment.hasNoResource(split)) {
                    name = EmbedDataExperiment.makeRelativeName(commonPath, split.resourceUri);
                    split.file = "%{PWD}/" + name;
                    dataSourceFilter.setUri(URISplit.format((URISplit)split));
                } else if (uri.equals("vap+internal:")) {
                    QDataSet ds = datasets[dsfCount];
                    logger.log(Level.FINE, "automatically embedding internal data as qds: {0}", ds);
                    File tmpFile = File.createTempFile("autoplot", ".qds");
                    String fname = "internal/data" + nameGenCount + ".qds";
                    SimpleStreamFormatter ff = new SimpleStreamFormatter();
                    FileOutputStream pout = new FileOutputStream(tmpFile);
                    InputStream pin = null;
                    try {
                        ff.format(ds, (OutputStream)pout, false);
                        ((OutputStream)pout).close();
                        pin = new FileInputStream(tmpFile);
                        EmbedDataExperiment.writeToZip(out, fname, pin);
                        if (!tmpFile.delete()) {
                            logger.log(Level.WARNING, "unable to delete temp file: {0}", tmpFile);
                        }
                        dataSourceFilter.setUri("%{PWD}/" + fname);
                    }
                    catch (StreamException ex) {
                        logger.log(Level.WARNING, null, ex);
                    }
                    finally {
                        ((OutputStream)pout).close();
                        if (pin != null) {
                            pin.close();
                        }
                    }
                    ++nameGenCount;
                }
                ++dsfCount;
            }
            for (Plot plot : dom.getPlots()) {
                uri = plot.getTicksURI();
                split = URISplit.parse((String)uri);
                if (uri.trim().length() <= 0 || EmbedDataExperiment.hasNoResource(split)) continue;
                name = EmbedDataExperiment.makeRelativeName(commonPath, split.resourceUri);
                split.file = "%{PWD}/" + name;
                plot.setTicksURI(URISplit.format((URISplit)split));
            }
            String string = dom.getEventsListUri();
            URISplit split2 = URISplit.parse((String)string);
            if (string.trim().length() > 0 && !EmbedDataExperiment.hasNoResource(split2)) {
                String name3 = EmbedDataExperiment.makeRelativeName(commonPath, split2.resourceUri);
                split2.file = "%{PWD}/" + name3;
                dom.setEventsListUri(URISplit.format((URISplit)split2));
            }
            ZipEntry zipEntry = new ZipEntry("default.vap");
            out.putNextEntry(zipEntry);
            StatePersistence.saveState(new NoCloseOutputStream(out), (Object)dom, "");
        }
        finally {
            if (out != null) {
                try {
                    out.closeEntry();
                }
                finally {
                    out.close();
                }
            }
            fout.close();
            if (!new File(f + ".tmp").renameTo(f)) {
                logger.log(Level.WARNING, "unable to rename file: {0}", new File(f + ".tmp"));
            }
        }
    }

    private static class NoCloseOutputStream
    extends OutputStream {
        OutputStream out;

        NoCloseOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }
    }
}

